;==========================================================================
;Version history:
;==========================================================================
;2010/01/14     First edition
;==========================================================================
;Declaration of Interrupt Vectors
;==========================================================================
        .EXTERN V_NMI           ;81AH, 81BH
        .EXTERN V_RESET         ;81CH, 81DH
        .EXTERN V_IRQ_None      ;81EH, 81FH

        .EXTERN V_IRQ_TMA       ;820H, 821H
        .EXTERN V_IRQ_TMB       ;822H, 823H
        .EXTERN V_IRQ_TMC       ;824H, 825H
        .EXTERN V_IRQ_1024      ;826H, 827H
        .EXTERN V_IRQ_4096      ;828H, 829H
        .EXTERN V_IRQ_16Hz      ;82AH, 82BH
        .EXTERN V_IRQ_2Hz       ;82CH, 82DH
        .EXTERN V_IRQ_KEY       ;82EH, 82FH
        .EXTERN V_IRQ_EXT       ;830H, 831H
        .EXTERN V_IRQ_SPU       ;832H, 833H
        .EXTERN V_IRQ_SPI       ;834H, 835H
        .EXTERN V_IRQ_ADC       ;836H, 837H
        .EXTERN V_IRQ_QD1F      ;838H, 839H
        .EXTERN V_IRQ_QD1B      ;83AH, 83BH
        .EXTERN V_IRQ_QD2F      ;83CH, 83DH
        .EXTERN V_IRQ_QD2B      ;83EH, 83FH

        .PUBLIC T_StepTable
;==========================================================================
;Stack Area (To modify the size, please change the section address of STACK in Prog.lik)
;==========================================================================
STACK:          .SECTION
Stack:          .DS     1       ;Declared for stack area. If a section overlaps this section, a warning will be appeared.
                .ENDS
;==========================================================================
;ADPCM Table(ADPCM only, for SPU, user cannot modify it)
;==========================================================================
SYS_TABLE:      .SECTION
T_StepTable:
        .DB     80H, 90H, 88H, 97H, A0H, B0H, A6H, B5H
        .DB     90H, 9EH, 98H, A5H, ACH, BAH, B2H, BFH
        .DB     C0H, D0H, C4H, D3H, E0H, F0H, E2H, F1H
        .DB     C8H, D6H, CCH, D9H, E4H, F2H, E6H, F3H
        .DB     A0H, ACH, A8H, B3H, B8H, C4H, BEH, C9H
        .DB     B0H, BAH, B8H, C1H, C4H, CEH, CAH, D3H
        .DB     D0H, DCH, D4H, DFH, E8H, F4H, EAH, F5H
        .DB     D8H, E2H, DCH, E5H, ECH, F6H, EEH, F7H
        .DB     00H, 10H, 00H, 0FH, 20H, 30H, 1EH, 2DH
        .DB     00H, 0EH, 00H, 0DH, 1CH, 2AH, 1AH, 27H
        .DB     40H, 50H, 3CH, 4BH, 60H, 70H, 5AH, 69H
        .DB     38H, 46H, 34H, 41H, 54H, 62H, 4EH, 5BH
        .DB     00H, 0CH, 00H, 0BH, 18H, 24H, 16H, 21H
        .DB     00H, 0AH, 00H, 09H, 14H, 1EH, 12H, 1BH
        .DB     30H, 3CH, 2CH, 37H, 48H, 54H, 42H, 4DH
        .DB     28H, 32H, 24H, 2DH, 3CH, 46H, 36H, 3FH
        .DB     C0H, C8H, C8H, CFH, D0H, D8H, D6H, DDH
        .DB     D0H, D6H, D8H, DDH, DCH, E2H, E2H, E7H
        .DB     E0H, E8H, E4H, EBH, F0H, F8H, F2H, F9H
        .DB     E8H, EEH, ECH, F1H, F4H, FAH, F6H, FBH
        .DB     E0H, E4H, E8H, EBH, E8H, ECH, EEH, F1H
        .DB     F0H, F2H, F8H, F9H, F4H, F6H, FAH, FBH
        .DB     F0H, F4H, F4H, F7H, F8H, FCH, FAH, FDH
        .DB     F8H, FAH, FCH, FDH, FCH, FEH, FEH, FFH
        .DB     00H, 08H, 00H, 07H, 10H, 18H, 0EH, 15H
        .DB     00H, 06H, 00H, 05H, 0CH, 12H, 0AH, 0FH
        .DB     20H, 28H, 1CH, 23H, 30H, 38H, 2AH, 31H
        .DB     18H, 1EH, 14H, 19H, 24H, 2AH, 1EH, 23H
        .DB     00H, 04H, 00H, 03H, 08H, 0CH, 06H, 09H
        .DB     00H, 02H, 00H, 01H, 04H, 06H, 02H, 03H
        .DB     10H, 14H, 0CH, 0FH, 18H, 1CH, 12H, 15H
        .DB     08H, 0AH, 04H, 05H, 0CH, 0EH, 06H, 07H

        .DB     27D, 31D, 28D, 32D      ;Length(ADPCM only)
                .ENDS
;==========================================================================
;Definition of Vector Table
;==========================================================================
VECT_TABLE:     .SECTION
        .DW     V_NMI           ;NMI
        .DW     V_RESET         ;Reset
        .DW     V_IRQ_None      ;IRQ

        .DW     V_IRQ_TMA       ;820H, 821H
        .DW     V_IRQ_TMB       ;822H, 823H
        .DW     V_IRQ_TMC       ;824H, 825H
        .DW     V_IRQ_1024      ;826H, 827H
        .DW     V_IRQ_4096      ;828H, 829H
        .DW     V_IRQ_16Hz      ;82AH, 82BH
        .DW     V_IRQ_2Hz       ;82CH, 82DH
        .DW     V_IRQ_KEY       ;82EH, 82FH
        .DW     V_IRQ_EXT       ;830H, 831H
        .DW     V_IRQ_SPU       ;832H, 833H
        .DW     V_IRQ_SPI       ;834H, 835H
        .DW     V_IRQ_ADC       ;836H, 837H
        .DW     V_IRQ_QD1F      ;838H, 839H
        .DW     V_IRQ_QD1B      ;83AH, 83BH
        .DW     V_IRQ_QD2F      ;83CH, 83DH
        .DW     V_IRQ_QD2B      ;83EH, 83FH
                .ENDS
;==========================================================================
